package userFramework;

import java.util.HashMap;
import thirdPartyToolFramework.StateListener;

public class AbstractUserState implements UserState{
	private HashMap<Integer, String> events = new HashMap<Integer, String>();
	private HashMap<StateListener, int[]> register = new HashMap<StateListener, int[]>();
	
	public void update(int eventType, String event){
		events.put(eventType, event);
	}
	public String poll(StateListener listener){
		//return all events that the listener has registered for
		String message = "";
		
		for (int i=0; i < register.get(listener).length; i++){
			message += events.get(register.get(listener)[i]);
		}
		return message;
	}
	public String query(int eventType){
		//return the events that match the given type
		return events.get(eventType);
	}
	public void register(StateListener listener, int[] events){
		register.put(listener, events);
	}
}
